# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

from .sdvaluebasetype import SDValueBaseType
from .sdapiobject import SDAPIObject
from .sdbasetypes import ColorRGBA
from .sdapiobject import SDApiError
from .apiexception import APIException

class SDValueSpotColor(SDValueBaseType):
    """
    Class representing a spot color Value
    """
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDValueSpotColor
        """
        super(SDValueSpotColor, self).__init__(APIContext, handle, *args, **kwargs)

    def get(self) -> ColorRGBA:
        """
        Get the base type value as ColorRGBA

        """
        outValue = ColorRGBA()
        _res = self.mAPIContext.SDValueSpotColor_get(self.mHandle, ctypes.byref(outValue))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outValue

